//
//  GSSelectGlyphsDialogController.h
//  GlyphsKit
//
//  Created by Georg Seifert on 13/09/14.
//  Copyright (c) 2014 Georg Seifert. All rights reserved.
//

#import <Cocoa/Cocoa.h>

NS_ASSUME_NONNULL_BEGIN

typedef void (^SelectGlyphHandler)(NSArray *__nullable result, NSString *searchString);

@class GSFindGlyphSortDescriptor;

@interface GSSelectGlyphsDialogController : NSWindowController <NSMenuDelegate>

+ (instancetype)sharedHandler;

- (instancetype)init __attribute__((unavailable("use sharedHandler")));

@property (nonatomic, weak) IBOutlet NSTextField *glyphsSelectTextField;
@property (nonatomic, weak) IBOutlet NSArrayController *glyphListController;
@property (nonatomic, weak) IBOutlet NSTableView *glyphListTableView;
@property (nonatomic, weak) IBOutlet NSPopUpButton *searchModeButton;

- (void)showWithCompletion:(SelectGlyphHandler)handler;

- (void)setMasterID:(NSString *)masterID;

- (void)setTitle:(NSString *)title;

- (void)setContent:(nullable NSArray *)content;

@property (nonatomic, nullable, strong) NSString *search;

@property (nonatomic, nullable, strong) NSString *searchUserDefaultsKey;

- (void)setAllowsMultipleSelection:(BOOL)allowsMultipleSelection;

- (IBAction)findOK:(id)sender;

- (IBAction)findChanged:(id)sender;

- (IBAction)optionChanged:(id)sender;

@property (strong, nonatomic, nullable) NSArray *selectedGlyphs;

@end

NS_ASSUME_NONNULL_END
